import 'package:admin_desktop/application/bookings/booking_provider.dart';
import 'package:admin_desktop/infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/infrastructure/services/enums.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

class StatusModal extends StatelessWidget {
  const StatusModal({super.key});

  @override
  Widget build(BuildContext context) {
    return Consumer(builder: (context, ref, child) {
      return Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          6.verticalSpace,
          Wrap(
            spacing: 8,
            runSpacing: 6,
            children: [
              ...BookingStatus.values.map((e) => _statusItem(
                  status: AppHelpers.getBookingStatus(e),
                  onTap: () {
                    ref.read(bookingProvider.notifier).changeStatus(
                          status: AppHelpers.getBookingStatus(e),
                          context: context,
                        );
                    // ref.read(bookingProvider.notifier).changeTabIndex(e.index+1, context);
                    Navigator.pop(context);
                  },
                  active: ref.watch(bookingProvider).status ==
                      AppHelpers.getBookingStatus(e))),
            ],
          ),
        ],
      );
    });
  }
}

GestureDetector _statusItem({
  required String status,
  required bool active,
  required VoidCallback onTap,
}) {
  return GestureDetector(
    onTap: onTap,
    child: Container(
      padding: REdgeInsets.symmetric(horizontal: 10, vertical: 8),
      decoration: BoxDecoration(
        color:
            AppHelpers.getStatusColor(status).withOpacity(active ? 0.5 : 0.3),
        border: Border.all(
          width: 2,
          color: active ? AppHelpers.getStatusColor(status) : Style.transparent,
        ),
        borderRadius: BorderRadius.circular(12.r),
      ),
      child: Row(
        mainAxisSize: MainAxisSize.min,
        children: [
          Text(
            AppHelpers.getTranslation(status),
            style: Style.interNormal(
              size: 16,
              color: active ? Style.white : Style.black,
            ),
          ),
        ],
      ),
    ),
  );
}
